
IF OBJECT_ID('P_EXP_CTB_MOV_VENDAS_CONTABIL_CARTAO') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_CARTAO;
    END;
GO

CREATE PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_CARTAO(@CD_EMP      INT,
                                                      @CD_FILIAL   INT,
                                                      @DT_INI      DATETIME,
                                                      @DT_FIM      DATETIME,
                                                      @FLAG_LIMPAR INT      = 0)
WITH ENCRYPTION
AS
SET NOCOUNT ON;
    BEGIN TRY
        BEGIN
            DECLARE @RS_CD_EMP INT;
            DECLARE @RS_CD_FILIAL INT;
            DECLARE @RS_CD_CLI INT;
            DECLARE @RS_DT_MOV DATETIME;
            DECLARE @RS_VLR_CARTAO MONEY;
            DECLARE @RS_NM_CARTAO VARCHAR(100);
            DECLARE @RS_CD_CTB_CNT_RED INT;
            DECLARE @RS_CD_CTB_CNT VARCHAR(50);
            DECLARE @RS_VLR_SAQUE_CARTAO MONEY;
            DECLARE @RS_TP_TRANSACAO INT;
            DECLARE @RS_DS_TRANSACAO VARCHAR(100);
            DECLARE @RS_TP_DEB_CRED INT;
			DECLARE @RS_TIPO_DOC INT;
            DECLARE @RET_CD_CTB_CNT VARCHAR(100);
            DECLARE @RET_CD_CTB_CNT_RED INT;
            DECLARE @RET_DS_CNT VARCHAR(100);
            DECLARE @RET_NR_CNT VARCHAR(50);
            DECLARE @RET_TP_CNT INT;
            DECLARE @RET_TITULAR_CNT VARCHAR(200);
            DECLARE @RET_RZ_CLI VARCHAR(200);
            DECLARE @CD_MOVIMENTO INT;
            DECLARE @MOVIMENTO VARCHAR(50);
            DECLARE @OPERACAO VARCHAR(50);
            DECLARE @OPERACAO_DEBITO VARCHAR(50);
            DECLARE @HIST VARCHAR(250);
		    DECLARE @NR_CONTROLE	VARCHAR (50)

            ------------------------------------------------------------------------------------------------------------------------------
            --CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
            ------------------------------------------------------------------------------------------------------------------------------
			print 'P_EXP_CTB_MOV_VENDAS_CONTABIL_CARTAO - EXEC 1 ' + CONVERT(VARCHAR, GETDATE(), 108);
            EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV
                 @FLAG_LIMPAR;

/************************************************************************************************************************/
-- Removido a funcao abaixo
 --UFD_EXP_CTB_MOV_CARTAO(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM, 0) T	

		create table #RS_RETURN (CD_EMP	INT, 
					 CD_FILIAL		INT, 
					 CD_ADM_CARTAO		INT, 
					 CD_CLI			INT, 
					 DT_MOV			DATETIME, 
					 VLR_CARTAO		MONEY, 
					 NM_CARTAO		VARCHAR(100), 
					 CD_CTB_CNT_RED	INT, 
					 CD_CTB_CNT		VARCHAR(50), 
					 VLR_SAQUE_CARTAO	MONEY, 
					 TP_TRANSACAO		INT, 
					 DS_TRANSACAO		VARCHAR(100),
					 TP_DEB_CRED		tinyint,
					 TIPO_DOC           TINYINT);

			-- TIPO_DOC
			-- 0 - VENDAS FISCAIS
			-- 1 - NO FISCAL - RECARGA
			-- 2   NO FISCAL - RECEBIMENTOS DIVERSOS
			-- 3   NO FISCAL - RPS  - RECIBO PROVISORIO DE SERVICO
			-- 4   NO FISCAL - SUPER TROCO

		  INSERT INTO #RS_RETURN
		  SELECT     
			  PDV_VD.CD_EMP, 
			  PDV_VD.CD_FILIAL, 
			  PDV_VD_TEF.CD_ADM_CARTAO ,
			  0 CD_CLI, 
			  PDV_VD.DT_VD AS DT_MOV,
              ISNULL(SUM (PDV_VD_TEF.VL_CARTAO - ISNULL(T2.VLR_TOT_CUPOM ,0)) ,0) AS VLR_CARTAO,
			  '' NM_CARTAO, 
			  '' CD_CTB_CNT_RED, 
			  '' CD_CTB_CNT, 
			  ISNULL(SUM(PDV_VD_TEF.VL_SAQUE_CARTAO),0)  AS VLR_SAQUE_CARTAO,
			  0 AS TP_TRANSACAO,
			 'VENDAS' AS DS_TRANSACAO	,
			  9 AS TP_DEB_CRED,
			  0 AS TIPO_DOC			
		   FROM         
			 PDV_VD_TEF 
			 INNER JOIN PDV_VD ON 
			 PDV_VD_TEF.CD_VD = PDV_VD.CD_VD AND 
			 PDV_VD_TEF.CD_FILIAL = PDV_VD.CD_FILIAL AND 
			 PDV_VD_TEF.CD_EMP = PDV_VD.CD_EMP 
			
			 LEFT  JOIN (SELECT PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_EMP, 
                        PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_FILIAL, 
                        PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_CX, 
                        PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.NR_ECF, 
                        PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
                        PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM 
                FROM PDV_CUPOM_NAO_FISCAL_SUPER_TROCO  
                INNER JOIN PDV_CUPOM_NAO_FISCAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_EMP 
                AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_FILIAL 
                AND PDV_CUPOM_NAO_FISCAL.CD_CTR = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_CTR 
                AND PDV_CUPOM_NAO_FISCAL.CD_CX = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_CX 
                WHERE PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0 ) T2 ON PDV_VD.CD_EMP = T2.CD_EMP 
                AND PDV_VD.CD_FILIAL = T2.CD_FILIAL 
                AND PDV_VD.CD_CX = T2.CD_CX 
                AND PDV_VD.NR_ECF = T2.NR_ECF 
                AND PDV_VD.DT_VD = T2.DT_CUPOM

		  WHERE 
			  PDV_VD.ST_VD = 0 
			  and PDV_VD.cd_emp=@CD_EMP
			  and PDV_VD.cd_filial =@CD_FILIAL
			  and PDV_VD.dt_vd BETWEEN  @DT_INI AND @DT_FIM
		  GROUP BY 
			  PDV_VD_TEF.CD_ADM_CARTAO ,
			  PDV_VD.CD_EMP, 
			  PDV_VD.CD_FILIAL, 
			  PDV_VD.DT_VD;

		  INSERT INTO #RS_RETURN	
		  
		  SELECT     
			 PDV_RECBTO_TEF.CD_EMP, 
			 PDV_RECBTO_TEF.CD_FILIAL, 
			 PDV_RECBTO_TEF.CD_ADM_CARTAO,
			 0 CD_CLI,
			 PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
			 ISNULL(PDV_RECBTO_TEF.VL_CARTAO,0) AS VLR_CARTAO, 
			 '' NM_CARTAO, 
			 '' CD_CTB_CNT_RED, 
			 '' CD_CTB_CNT, 
			 ISNULL(PDV_RECBTO_TEF.VL_SAQUE_CARTAO,0) AS VLR_SAQUE_CARTAO,
			 1 AS TP_TRANSACAO,
			 'VENDAS' AS DS_TRANSACAO,
			 9 AS TP_DEB_CRED,
			 1 AS TIPO_DOC	
		  FROM         
			 PDV_RECBTO_TEF 
			 INNER JOIN PDV_CUPOM_NAO_FISCAL_TEF ON 
			 PDV_RECBTO_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP AND 
			 PDV_RECBTO_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL AND 
			 PDV_RECBTO_TEF.CD_RECTO_TEF = PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF 
			 INNER JOIN PDV_CUPOM_NAO_FISCAL ON 
			 PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND 
			 PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND 
			 PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR  
		  WHERE 
			 PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
			 AND TP_CUPOM_NAO_FISCAL = 3 
			 AND ST_CUPOM not in(1,2,3) 
			 and PDV_RECBTO_TEF.cd_emp=@CD_EMP
			 and PDV_RECBTO_TEF.cd_filial =@CD_FILIAL
			 and PDV_CUPOM_NAO_FISCAL.DT_CUPOM  BETWEEN  @DT_INI AND @DT_FIM
			 and PDV_RECBTO_TEF.VL_CARTAO > 0;
--

		  INSERT INTO #RS_RETURN	
		  SELECT     
			 PDV_RECBTO_TEF.CD_EMP, 
			 PDV_RECBTO_TEF.CD_FILIAL, 
			 PDV_RECBTO_TEF.CD_ADM_CARTAO,
			 0 CD_CLI,
			 PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
			 ISNULL(PDV_RECBTO_TEF.VL_CARTAO,0) AS VLR_CARTAO, 
			 '' NM_CARTAO, 
			 '' CD_CTB_CNT_RED, 
			 '' CD_CTB_CNT, 
			 ISNULL(PDV_RECBTO_TEF.VL_SAQUE_CARTAO,0) AS VLR_SAQUE_CARTAO,
			 1 AS TP_TRANSACAO,
			 'VENDAS' AS DS_TRANSACAO,
			 9 AS TP_DEB_CRED,
			 2 AS TIPO_DOC	
			FROM PDV_CUPOM_NAO_FISCAL
			INNER JOIN PDV_CUPOM_NAO_FISCAL_EST_RECB_PDV ON PDV_CUPOM_NAO_FISCAL.CD_EMP = PDV_CUPOM_NAO_FISCAL_EST_RECB_PDV.CD_EMP
				AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_EST_RECB_PDV.CD_FILIAL
				AND PDV_CUPOM_NAO_FISCAL.CD_CTR = PDV_CUPOM_NAO_FISCAL_EST_RECB_PDV.CD_CTR
			INNER JOIN EST_RECB_PDV ON PDV_CUPOM_NAO_FISCAL_EST_RECB_PDV.CD_EMP = EST_RECB_PDV.CD_EMP
				AND PDV_CUPOM_NAO_FISCAL_EST_RECB_PDV.CD_RECB_PDV = EST_RECB_PDV.CD_RECB_PDV
			INNER JOIN  PDV_CUPOM_NAO_FISCAL_TEF ON  
			 PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND 
			 PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND 
			 PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR 
			 INNER JOIN PDV_RECBTO_TEF ON
			  PDV_RECBTO_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP AND 
			 PDV_RECBTO_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL AND 
			 PDV_RECBTO_TEF.CD_RECTO_TEF = PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF 
			  
		  WHERE 
			  PDV_CUPOM_NAO_FISCAL.cd_emp=@CD_EMP
			 and PDV_CUPOM_NAO_FISCAL.cd_filial =@CD_FILIAL
			 and PDV_CUPOM_NAO_FISCAL.DT_CUPOM  BETWEEN  @DT_INI AND @DT_FIM 
			 AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
			 AND TP_CUPOM_NAO_FISCAL not in (7,3)
			 AND PDV_CUPOM_NAO_FISCAL.VLR_CARTAO > 0;


		  INSERT INTO #RS_RETURN	
		  SELECT     
			 PDV_RECBTO_TEF.CD_EMP, 
			 PDV_RECBTO_TEF.CD_FILIAL, 
			 PDV_RECBTO_TEF.CD_ADM_CARTAO,
			 0 CD_CLI,
			 PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
			 ISNULL(PDV_RECBTO_TEF.VL_CARTAO,0) AS VLR_CARTAO, 
			 '' NM_CARTAO, 
			 '' CD_CTB_CNT_RED, 
			 '' CD_CTB_CNT, 
			 0 AS VLR_SAQUE_CARTAO,
			 1 AS TP_TRANSACAO,
			 'VENDAS' AS DS_TRANSACAO,
			 9 AS TP_DEB_CRED,
			 3 AS TIPO_DOC	
			FROM PDV_CUPOM_NAO_FISCAL
 			    INNER JOIN  PDV_CUPOM_NAO_FISCAL_TEF ON  
					 PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND 
					 PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND 
					 PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR 
					 INNER JOIN PDV_RECBTO_TEF ON
					  PDV_RECBTO_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP AND 
					 PDV_RECBTO_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL AND 
					 PDV_RECBTO_TEF.CD_RECTO_TEF = PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF 
			  
		  WHERE 
			  PDV_CUPOM_NAO_FISCAL.cd_emp=   @CD_EMP
			 and PDV_CUPOM_NAO_FISCAL.cd_filial =  @CD_FILIAL
			 and PDV_CUPOM_NAO_FISCAL.DT_CUPOM  BETWEEN  @DT_INI AND @DT_FIM 
			 AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
			 AND TP_CUPOM_NAO_FISCAL = 7 
			 AND PDV_CUPOM_NAO_FISCAL.VLR_CARTAO > 0
 

		INSERT INTO #RS_RETURN	
		  SELECT     
			  PDV_CUPOM_NAO_FISCAL.CD_EMP,
			  PDV_CUPOM_NAO_FISCAL.CD_FILIAL,
			  PDV_VD_TEF.CD_ADM_CARTAO,
			  0 CD_CLI, 
			  PDV_VD.DT_VD AS DT_MOV,
			   ISNULL( PDV_CUPOM_NAO_FISCAL.VLR_CARTAO ,0)	AS VLR_CARTAO, 
						  '' NM_CARTAO, 
						  '' CD_CTB_CNT_RED, 
						  '' CD_CTB_CNT, 
						  0 AS VLR_SAQUE_CARTAO,
						  1 AS TP_TRANSACAO,
						 'VENDAS' AS DS_TRANSACAO	,
						  9 AS TP_DEB_CRED,
						  4 AS TIPO_DOC
			FROM
				PDV_CUPOM_NAO_FISCAL
				LEFT JOIN RC_CLI ON
					PDV_CUPOM_NAO_FISCAL.CD_EMP = RC_CLI.CD_EMP
					AND PDV_CUPOM_NAO_FISCAL.CD_CLI = RC_CLI.CD_CLI
				INNER JOIN PDV_CUPOM_NAO_FISCAL_SUPER_TROCO ON
					PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP
					AND PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL
					AND PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR
					AND PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_CX = PDV_CUPOM_NAO_FISCAL.CD_CX
				INNER JOIN PDV_VD ON
					PDV_VD.NR_ECF = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.NR_ECF
					AND PDV_VD.CD_EMP = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_EMP
					AND PDV_VD.CD_FILIAL  = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_FILIAL
					AND PDV_VD.CD_CX  = PDV_CUPOM_NAO_FISCAL_SUPER_TROCO.CD_CX
				INNER JOIN PDV_VD_TEF ON  
					PDV_VD_TEF.CD_VD = PDV_VD.CD_VD AND 
						 PDV_VD_TEF.CD_FILIAL = PDV_VD.CD_FILIAL AND 
						 PDV_VD_TEF.CD_EMP = PDV_VD.CD_EMP  
			  
		  WHERE 
			  PDV_CUPOM_NAO_FISCAL.cd_emp=   @CD_EMP
			 and PDV_CUPOM_NAO_FISCAL.cd_filial =  @CD_FILIAL
			 and PDV_CUPOM_NAO_FISCAL.DT_CUPOM  BETWEEN  @DT_INI AND @DT_FIM 
			 AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
			 AND TP_CUPOM_NAO_FISCAL = 10
			 AND PDV_CUPOM_NAO_FISCAL.VLR_CARTAO > 0;

			 -- A VISTA
			 -- 1 PRAZO

			--RC_ADM_CARTAO.TP_ADM = 0 CREDITO TEF
			--RC_ADM_CARTAO.TP_ADM = 1 DEBITO TEF
			--RC_ADM_CARTAO.TP_ADM = 2 CREDITO POS
			--RC_ADM_CARTAO.TP_ADM = 3 DEBITO POS
			--RC_ADM_CARTAO.TP_ADM = 4  Convenio
			--RC_ADM_CARTAO.TP_ADM = 5 CARTAO PROPPRIO
			--RC_ADM_CARTAO.TP_ADM = 6 CREDIARIO
			--RC_ADM_CARTAO.TP_ADM = 7 PIX = TEF
			--RC_ADM_CARTAO.TP_ADM = 8 CASHBACK TEF

		  UPDATE R
		  SET
			 TP_DEB_CRED = CASE WHEN RC_ADM_CARTAO.TP_ADM IN (0,2,4,5,6,8) THEN 1  
							 ELSE 0 END,
			  CD_CLI	 = RC_CLI.CD_CLI, 
			  NM_CARTAO  = RC_CLI.RZ_CLI  + '-' + CAST(R.CD_ADM_CARTAO AS VARCHAR)       , 
			  CD_CTB_CNT_RED = RC_CLI.CD_CTB_CNT_RED, 
			  CD_CTB_CNT	= RC_CLI.CD_CTB_CNT 
		  FROM 
			 #RS_RETURN R
			 INNER JOIN RC_ADM_CARTAO_RC_CLI ON 
			 R.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
			 R.CD_ADM_CARTAO = RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO
			 INNER JOIN RC_CLI ON
			 RC_CLI.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
			 RC_CLI.CD_CLI = RC_ADM_CARTAO_RC_CLI.CD_CLI 
			 INNER JOIN RC_ADM_CARTAO ON 
			 R.CD_EMP = RC_ADM_CARTAO.CD_EMP AND 
			 R.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO;
     -----------------------------------------------------------------------------------------------

            DECLARE RS_RESULT CURSOR
            FOR SELECT T.CD_EMP
                     , T.CD_FILIAL
                     , T.CD_CLI
                     , T.DT_MOV
                     , T.VLR_CARTAO
                     , T.NM_CARTAO
                     , T.CD_CTB_CNT_RED
                     , T.CD_CTB_CNT
                     , T.VLR_SAQUE_CARTAO
                     , T.TP_TRANSACAO
                     , T.DS_TRANSACAO
                     , T.TP_DEB_CRED
					 , t.TIPO_DOC 
                FROM #RS_RETURN t

            --Abrindo cursor
            OPEN RS_RESULT; 
            --Atribuindo valores do select nas variveis
            FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_CD_CLI, @RS_DT_MOV, 
								    @RS_VLR_CARTAO, @RS_NM_CARTAO, @RS_CD_CTB_CNT_RED, @RS_CD_CTB_CNT, 
								    @RS_VLR_SAQUE_CARTAO, @RS_TP_TRANSACAO, @RS_DS_TRANSACAO, 
									@RS_TP_DEB_CRED, @RS_TIPO_DOC;
								

            --Iniciando lao
            WHILE @@FETCH_STATUS = 0
                BEGIN
                    IF @RS_TP_DEB_CRED = 0  -- VISTA
                        BEGIN
                            IF @RS_TP_TRANSACAO = 0  --  TP_TRANSACAO = 0 Fiscal, 1 No fiscal
                                BEGIN
									print 'SET 2 ' + CONVERT(VARCHAR, GETDATE(), 108);
                                    SET @CD_MOVIMENTO = 4;
                                    SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
                                    SET @OPERACAO_DEBITO = 'VENDAS - DEBITO';
                                    SET @HIST = 'VALOR REF. VENDAS - CARTAO A VISTA: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
                                END;
                            ELSE
                                BEGIN
								   IF @RS_TIPO_DOC = 1  
										BEGIN
											PRINT 'SET 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
											SET @CD_MOVIMENTO = 4;
											SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
											SET @OPERACAO_DEBITO = 'VENDAS - RECARGA CELULAR - DEBITO';
											SET @HIST = 'VALOR REF. RECARGA CELULAR - CARTAO A VISTA: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;

										 END

									ELSE	
									 
									  IF @RS_TIPO_DOC = 2  
									 									
										   BEGIN
											  PRINT 'SET 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
											  SET @CD_MOVIMENTO = 4;
											  SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
											  SET @OPERACAO_DEBITO = 'RECEBIMENTO DE TERCEIROS - DEBITO';
											  SET @HIST = 'VALOR REF. RECEBIMENTO DE TERCEIROS - CARTAO A VISTA: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;

											 END  
									 ELSE
									     IF  @RS_TIPO_DOC = 3  
											 BEGIN
												PRINT 'SET 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
												SET @CD_MOVIMENTO = 4;
												SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
												SET @OPERACAO_DEBITO = 'RPS - DEBITO';
												SET @HIST = 'VALOR REF. RECIBO PROVISORIO DE SERVICO - CARTAO A VISTA: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
											END
										ELSE
											  BEGIN
													PRINT 'SET 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
													SET @CD_MOVIMENTO = 4;
													SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
													SET @OPERACAO_DEBITO = 'VENDAS SUPER TROCO - DEBITO';
													SET @HIST = 'VALOR REF. SUPER TROCO - CARTAO A VISTA: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
												END
									 
                                END;
                        END;
                    ELSE  -- PRAZO

					       IF @RS_TP_TRANSACAO = 0
						  			BEGIN
										print 'SET 4 ' + CONVERT(VARCHAR, GETDATE(), 108);
										SET @CD_MOVIMENTO = 4;
										SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
										SET @OPERACAO_DEBITO = 'VENDAS - DEBITO';
										SET @HIST = 'VALOR REF. VENDAS - CARTAO A PRAZO: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
									END;
                            ELSE
                                BEGIN
								   IF @RS_TIPO_DOC = 1  
						  				BEGIN
											print 'SET 4 ' + CONVERT(VARCHAR, GETDATE(), 108);
											SET @CD_MOVIMENTO = 4;
											SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
											SET @OPERACAO_DEBITO = 'VENDAS - RECARGA CELULAR - DEBITO';
											SET @HIST = 'VALOR REF. RECARGA CELULAR - CARTAO A PRAZO: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
										END;

									ELSE	
									 
									  IF @RS_TIPO_DOC = 2  
									 									
										BEGIN
											print 'SET 4 ' + CONVERT(VARCHAR, GETDATE(), 108);
											SET @CD_MOVIMENTO = 4;
											SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
											SET @OPERACAO_DEBITO = 'RECEBIMENTOS DE TERCEIROS - DEBITO';
											SET @HIST = 'VALOR REF. RECEBIMENTOS DE TERCEIROS - CARTAO A PRAZO: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
										END; 
									
									ELSE
										
										IF @RS_TIPO_DOC = 3 
											BEGIN
												PRINT 'SET 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
												SET @CD_MOVIMENTO = 4;
												SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
												SET @OPERACAO_DEBITO = 'RPS - DEBITO';
												SET @HIST = 'VALOR REF. RECIBO PROVISORIO DE SERVICO - CARTAO A PRAZO: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
											END
										ELSE
										   BEGIN
												PRINT 'SET 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
												SET @CD_MOVIMENTO = 4;
												SET @MOVIMENTO = 'MOVIMENTO DE VENDAS';
												SET @OPERACAO_DEBITO = 'VENDAS SUPER TROCO - DEBITO';
												SET @HIST = 'VALOR REF. SUPER TROCO - CARTAO A PRAZO: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
											END
									 
                                END;
  
					print 'SELECT 5 ' + CONVERT(VARCHAR, GETDATE(), 108);
                    SELECT @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                         , @RET_RZ_CLI = RZ_CLI
                    FROM UFD_BUSCA_CONTA_RC_CLI(@RS_CD_EMP, @RS_CD_CLI, 0);
					SET @HIST = REPLACE (@HIST,'	',' ')
                    ------------------------------------------------------------------------------------------------------------------
                    --VENDAS CARTAO DEBITO/CREDITO - CLIENTES
                    ------------------------------------------------------------------------------------------------------------------	
				
				--===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
				--1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
				--2 - vendas icms
				--3 - vendas confins 
				--4 - vendas pis 
				--5 - vendas custo
				
				print 'SET 6 ' + CONVERT(VARCHAR, GETDATE(), 108);	
				SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
								  RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
			    --===========================================================================================================================	
					print 'INSERT 7 ' + CONVERT(VARCHAR, GETDATE(), 108);
                    INSERT INTO ##CTB_EXP_MOV
					   (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
					   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
					   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
					   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                           SELECT @RS_CD_EMP --CD_EMP
                                , @CD_FILIAL --CD_FILIAL_EXPORT
                                , @RS_CD_FILIAL --CD_FILIAL
                                , @CD_MOVIMENTO --CODIGO DO MOVIMENTO
                                , @MOVIMENTO --MOVIMENTO			
                                , '' --OPERACAO
                                , @OPERACAO_DEBITO --OPERACAO_DEBITO                					
                                , 0 --CD_CNT_RED_CREDITO
                                , '' --CD_CNT_CREDITO
                                , @RET_CD_CTB_CNT_RED --CD_CNT_RED_DEBITO
                                , @RET_CD_CTB_CNT --CD_CNT_DEBITO								
                                , @RS_DT_MOV --DT_MOV
                                , @HIST --HIST
                                , ROUND(@RS_VLR_CARTAO, 2) --VLR_LANC
                                , 'D' --TP_TRANSA
                                , 0 --RATEIO_CENTRO_CUSTO
                                , '' --DS_CENTRO_CUSTO
                                , 0 --CNT_CENTRO_CUSTO
                                , 0 --VLR_CENTRO_CUSTO											
                                , 'CLIENTES' --ORIG_CONTA
                                , @RS_CD_CLI --COD_CONTA
                                , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                , 'D' -- TIPO_LANCTO
                                , 0 AS CD_EVENTO
						  , 0  AS NR_DP
						  , 0  AS ANO
						  , @NR_CONTROLE AS NR_DOC
						  , 0 CD_BC_LANC;															-- CD_EVENTO
                    ------------------------------------------------------------------------------------------------------------------
                    --TROCO FACIL - CLIETNES 
                    ------------------------------------------------------------------------------------------------------------------
  					
                    IF @RS_VLR_SAQUE_CARTAO > 0
                        BEGIN
							print 'SET 8 ' + CONVERT(VARCHAR, GETDATE(), 108);
                            SET @HIST = 'VALOR REF. TROCO FCIL DBITO: '+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
							SET @HIST = REPLACE (@HIST,'	',' ')
                            SELECT @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                 , @RET_CD_CTB_CNT = CD_CTB_CNT
                                 , @RET_RZ_CLI = RZ_CLI
                            FROM UFD_BUSCA_CONTA_RC_CLI(@RS_CD_EMP, @RS_CD_CLI, 0);
							
							print 'INSERT 9 ' + CONVERT(VARCHAR, GETDATE(), 108);
                            INSERT INTO ##CTB_EXP_MOV
					   		(CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , @CD_MOVIMENTO --CODIGO DO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO			
                                        , '' --OPERACAO
                                        , 'VENDAS - DEBITO TROCO FACIL' --OPERACAO_DEBITO                					
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , @RET_CD_CTB_CNT_RED --CD_CNT_RED_DEBITO
                                        , @RET_CD_CTB_CNT --CD_CNT_DEBITO								
                                        , @RS_DT_MOV --DT_MOV
                                        , @HIST --HIST
                                        , ROUND(@RS_VLR_SAQUE_CARTAO, 2) --VLR_LANC
                                        , 'D' --TP_TRANSA
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'CLIENTES' --ORIG_CONTA
                                        , @RS_CD_CLI --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' -- TIPO_LANCTO
								, 0 AS CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 CD_BC_LANC;														-- CD_EVENTO
                            ------------------------------------------------------------------------------------------------------------------
                            --VENDAS CREDITO - Troco fcil 
                            ------------------------------------------------------------------------------------------------------------------

							print 'INSERT 10 ' + CONVERT(VARCHAR, GETDATE(), 108);
                            SET @HIST = 'VALOR REF. TROCO FCIL DBITO: SAQUE EM DINHEIRO NESTA DATA'+CAST(@RS_CD_CLI AS VARCHAR)+' - '+@RS_NM_CARTAO;
							SET @HIST = REPLACE (@HIST,'	',' ')
                            INSERT INTO ##CTB_EXP_MOV
					   		 (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , @CD_MOVIMENTO --CODIGO DO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO			
                                        , 'VENDAS - CREDITO TROCO FACIL' --OPERACAO
                                        , '' --OPERACAO_DEBITO                					
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO								
                                        , @RS_DT_MOV --DT_MOV
                                        , @HIST --HIST
                                        , ROUND(@RS_VLR_SAQUE_CARTAO, 2) --VLR_LANC
                                        , 'C' --TP_TRANSA
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 54 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
							     , 'D' -- TIPO_LANCTO
								, 0 AS CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;															-- CD_EVENTO	

                        END;										
								
                    --Atribuindo valores do select nas variveis
                    FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_CD_CLI, @RS_DT_MOV, @RS_VLR_CARTAO, @RS_NM_CARTAO, 
								    @RS_CD_CTB_CNT_RED, @RS_CD_CTB_CNT, @RS_VLR_SAQUE_CARTAO, 
								    @RS_TP_TRANSACAO, @RS_DS_TRANSACAO, @RS_TP_DEB_CRED,@RS_TIPO_DOC;
                END;
            CLOSE RS_RESULT;
            DEALLOCATE RS_RESULT;
        END;
    END TRY
    BEGIN CATCH
        CLOSE RS_RESULT;
        DEALLOCATE RS_RESULT;
        INSERT INTO ADM_ERRO
        (numero
       , severidade
       , estado
       , rotina
       , linha
       , mensagem
       , dtErro
        )
               SELECT ERROR_NUMBER() AS numero
                    , ERROR_SEVERITY() AS severidade
                    , ERROR_STATE() AS estado
                    , ERROR_PROCEDURE() AS rotina
                    , ERROR_LINE() AS linha
                    , ERROR_MESSAGE() AS mensagem
                    , GETDATE() AS dtErro;
    END CATCH;
	
print 'P_EXP_CTB_MOV_VENDAS_CONTABIL_CARTAO FINALIZADA!' 